<?php
	header('Content-Type: text/html; charset=utf-8');

	include('../../../inc/start.php');
	include('../../../inc/protect.php');

	if(!isset($_POST['token']) || $_SESSION['token'] != clean($_POST['token'], null))
		exit(json_encode(array('status' => 'error', 'text' => 'Неверный токен')));

	if(!strripos($users_groups[$_SESSION['rights']]['rights'], "t") !== false)
		exit;

	public function get_groups(&$users_groups, $access = ';', $id = '')
	{
		$tpl->result['groups'] = '';

		$tpl->load_template('settings_forum_groups.tpl');
			$tpl->set('{id}', $id);
			$tpl->set('{name}', 'Все');
			$tpl->set('{checked}', $access == ';' ? 'checked' : '');
		$tpl->compile('groups');

		$access = explode(';', $access);

		foreach($users_groups as &$value)
		{
			if(!$value['id'])
				continue;

			$tpl->load_template('settings_forum_groups.tpl');
				$tpl->set('{id}', $id);
				$tpl->set('{name}', 'Все');
				$tpl->set('{checked}', in_array($value['id'], $access) ? 'checked' : '');
			$tpl->compile('groups');
		}

		return $tpl->result['groups'];
	}

	$tpl = new Template;
	$tpl->dir = '../tpl/ajax/elements/';

	$tpl->result['content'] = '';

	$query = $pdo->query('SELECT `id`, `name`, `access` FROM `forums__section` ORDER BY `trim`');
			 $query->setFetchMode(PDO::FETCH_OBJ);

	while($section = $query->fetch())
	{
		$groups = get_groups($users_groups, $row->access, $row->id);

		$tpl->load_template('settings_forum_section.tpl');
			$tpl->set('{id}', $row->id);
			$tpl->set('{name}', $row->name);
			$tpl->set('{groups}', $groups);
		$tpl->compile('content');
	}

	if($tpl->result['content'] == '')
	{
		$tpl->load_template('settings_forum_section_none.tpl');
		$tpl->compile('content');
	}

	echo $tpl->result['content'];
?>